
const express = require('express');
const router = express.Router();
const db = require('../models/db');

router.get('/dashboard', async (req, res) => {
  if (!req.session.user || req.session.user.role !== 'admin') return res.redirect('/login');
  const [exams] = await db.query('SELECT * FROM exams');
  res.render('admin_dashboard', { user: req.session.user, exams });
});

router.post('/create-exam', async (req, res) => {
  const { title, description, duration } = req.body;
  await db.query('INSERT INTO exams (title, description, duration) VALUES (?, ?, ?)', [title, description, duration]);
  res.redirect('/admin/dashboard');
});

router.post('/add-question', async (req, res) => {
  const { exam_id, question_text, option_a, option_b, option_c, option_d, correct_option } = req.body;
  await db.query('INSERT INTO questions (exam_id, question_text, option_a, option_b, option_c, option_d, correct_option) VALUES (?, ?, ?, ?, ?, ?, ?)',
    [exam_id, question_text, option_a, option_b, option_c, option_d, correct_option]);
  res.redirect('/admin/dashboard');
});

router.get('/results', async (req, res) => {
  const [results] = await db.query('SELECT * FROM results');
  res.render('results', { results });
});

router.post('/delete-exam', async (req, res) => {
  const { exam_id } = req.body;
  await db.query('DELETE FROM exams WHERE id = ?', [exam_id]);
  await db.query('DELETE FROM questions WHERE exam_id = ?', [exam_id]);
  res.redirect('/admin/dashboard');
});

module.exports = router;
